/*
 * Decompiled with CFR 0.152.
 */
package org.bson.types;

import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.net.NetworkInterface;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.Enumeration;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ObjectId
implements Comparable<ObjectId>,
Serializable {
    private static final long serialVersionUID = -4415279469780082174L;
    static final Logger LOGGER = Logger.getLogger("org.bson.ObjectId");
    final int _time;
    final int _machine;
    final int _inc;
    boolean _new;
    private static AtomicInteger _nextInc = new AtomicInteger(new Random().nextInt());
    private static final int _genmachine;

    public static ObjectId get() {
        return new ObjectId();
    }

    public static boolean isValid(String string) {
        if (string == null) {
            return false;
        }
        int n = string.length();
        if (n != 24) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F') continue;
            return false;
        }
        return true;
    }

    public static ObjectId massageToObjectId(Object object) {
        String string;
        if (object == null) {
            return null;
        }
        if (object instanceof ObjectId) {
            return (ObjectId)object;
        }
        if (object instanceof String && ObjectId.isValid(string = object.toString())) {
            return new ObjectId(string);
        }
        return null;
    }

    public ObjectId(Date date) {
        this(date, _genmachine, _nextInc.getAndIncrement());
    }

    public ObjectId(Date date, int n) {
        this(date, _genmachine, n);
    }

    public ObjectId(Date date, int n, int n2) {
        this._time = (int)(date.getTime() / 1000L);
        this._machine = n;
        this._inc = n2;
        this._new = false;
    }

    public ObjectId(String string) {
        this(string, false);
    }

    public ObjectId(String string, boolean bl) {
        if (!ObjectId.isValid(string)) {
            throw new IllegalArgumentException("invalid ObjectId [" + string + "]");
        }
        if (bl) {
            string = ObjectId.babbleToMongod(string);
        }
        byte[] byArray = new byte[12];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)Integer.parseInt(string.substring(i * 2, i * 2 + 2), 16);
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        this._time = byteBuffer.getInt();
        this._machine = byteBuffer.getInt();
        this._inc = byteBuffer.getInt();
        this._new = false;
    }

    public ObjectId(byte[] byArray) {
        if (byArray.length != 12) {
            throw new IllegalArgumentException("need 12 bytes");
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        this._time = byteBuffer.getInt();
        this._machine = byteBuffer.getInt();
        this._inc = byteBuffer.getInt();
        this._new = false;
    }

    public ObjectId(int n, int n2, int n3) {
        this._time = n;
        this._machine = n2;
        this._inc = n3;
        this._new = false;
    }

    public ObjectId() {
        this._time = (int)(System.currentTimeMillis() / 1000L);
        this._machine = _genmachine;
        this._inc = _nextInc.getAndIncrement();
        this._new = true;
    }

    public int hashCode() {
        int n = this._time;
        n += this._machine * 111;
        return n += this._inc * 17;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        ObjectId objectId = ObjectId.massageToObjectId(object);
        if (objectId == null) {
            return false;
        }
        return this._time == objectId._time && this._machine == objectId._machine && this._inc == objectId._inc;
    }

    public String toStringBabble() {
        return ObjectId.babbleToMongod(this.toStringMongod());
    }

    public String toStringMongod() {
        byte[] byArray = this.toByteArray();
        StringBuilder stringBuilder = new StringBuilder(24);
        for (int i = 0; i < byArray.length; ++i) {
            int n = byArray[i] & 0xFF;
            String string = Integer.toHexString(n);
            if (string.length() == 1) {
                stringBuilder.append("0");
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public byte[] toByteArray() {
        byte[] byArray = new byte[12];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.putInt(this._time);
        byteBuffer.putInt(this._machine);
        byteBuffer.putInt(this._inc);
        return byArray;
    }

    static String _pos(String string, int n) {
        return string.substring(n * 2, n * 2 + 2);
    }

    public static String babbleToMongod(String string) {
        int n;
        if (!ObjectId.isValid(string)) {
            throw new IllegalArgumentException("invalid object id: " + string);
        }
        StringBuilder stringBuilder = new StringBuilder(24);
        for (n = 7; n >= 0; --n) {
            stringBuilder.append(ObjectId._pos(string, n));
        }
        for (n = 11; n >= 8; --n) {
            stringBuilder.append(ObjectId._pos(string, n));
        }
        return stringBuilder.toString();
    }

    public String toString() {
        return this.toStringMongod();
    }

    int _compareUnsigned(int n, int n2) {
        long l = 0xFFFFFFFFL;
        l = (long)n & l;
        long l2 = 0xFFFFFFFFL;
        long l3 = l - (l2 = (long)n2 & l2);
        if (l3 < Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        if (l3 > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)l3;
    }

    @Override
    public int compareTo(ObjectId objectId) {
        if (objectId == null) {
            return -1;
        }
        int n = this._compareUnsigned(this._time, objectId._time);
        if (n != 0) {
            return n;
        }
        n = this._compareUnsigned(this._machine, objectId._machine);
        if (n != 0) {
            return n;
        }
        return this._compareUnsigned(this._inc, objectId._inc);
    }

    public int getMachine() {
        return this._machine;
    }

    public long getTime() {
        return (long)this._time * 1000L;
    }

    public int getTimeSecond() {
        return this._time;
    }

    public int getInc() {
        return this._inc;
    }

    public int _time() {
        return this._time;
    }

    public int _machine() {
        return this._machine;
    }

    public int _inc() {
        return this._inc;
    }

    public boolean isNew() {
        return this._new;
    }

    public void notNew() {
        this._new = false;
    }

    public static int getGenMachineId() {
        return _genmachine;
    }

    public static int getCurrentInc() {
        return _nextInc.get();
    }

    public static int _flip(int n) {
        int n2 = 0;
        n2 |= n << 24 & 0xFF000000;
        n2 |= n << 8 & 0xFF0000;
        n2 |= n >> 8 & 0xFF00;
        return n2 |= n >> 24 & 0xFF;
    }

    static {
        try {
            int n;
            Object object;
            try {
                StringBuilder stringBuilder = new StringBuilder();
                Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
                while (enumeration.hasMoreElements()) {
                    object = enumeration.nextElement();
                    stringBuilder.append(((NetworkInterface)object).toString());
                }
                n = stringBuilder.toString().hashCode() << 16;
            }
            catch (Throwable throwable) {
                LOGGER.log(Level.WARNING, throwable.getMessage(), throwable);
                n = new Random().nextInt() << 16;
            }
            LOGGER.fine("machine piece post: " + Integer.toHexString(n));
            int n2 = new Random().nextInt();
            try {
                n2 = ManagementFactory.getRuntimeMXBean().getName().hashCode();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            object = ObjectId.class.getClassLoader();
            int n3 = object != null ? System.identityHashCode(object) : 0;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(Integer.toHexString(n2));
            stringBuilder.append(Integer.toHexString(n3));
            int n4 = stringBuilder.toString().hashCode() & 0xFFFF;
            LOGGER.fine("process piece: " + Integer.toHexString(n4));
            _genmachine = n | n4;
            LOGGER.fine("machine : " + Integer.toHexString(_genmachine));
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }
}

