/*
 * Decompiled with CFR 0.152.
 */
package org.bson.util;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.bson.util.Assertions;

abstract class AbstractCopyOnWriteMap<K, V, M extends Map<K, V>>
implements ConcurrentMap<K, V>,
Serializable {
    private static final long serialVersionUID = 4508989182041753878L;
    private volatile M delegate;
    private final transient Lock lock = new ReentrantLock();
    private final View<K, V> view;

    protected <N extends Map<? extends K, ? extends V>> AbstractCopyOnWriteMap(N n, View.Type type) {
        this.delegate = (Map)Assertions.notNull("delegate", this.copy(Assertions.notNull("map", n)));
        this.view = Assertions.notNull("viewType", type).get(this);
    }

    abstract <N extends Map<? extends K, ? extends V>> M copy(N var1);

    @Override
    public final void clear() {
        this.lock.lock();
        try {
            this.set(this.copy(Collections.emptyMap()));
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final V remove(Object object) {
        this.lock.lock();
        try {
            Object v;
            if (!this.delegate.containsKey(object)) {
                V v2 = null;
                return v2;
            }
            M m = this.copy();
            try {
                v = m.remove(object);
                this.set(m);
            }
            catch (Throwable throwable) {
                this.set(m);
                throw throwable;
            }
            return v;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object object, Object object2) {
        this.lock.lock();
        try {
            if (this.delegate.containsKey(object) && this.equals(object2, this.delegate.get(object))) {
                M m = this.copy();
                m.remove(object);
                this.set(m);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean replace(K k, V v, V v2) {
        this.lock.lock();
        try {
            if (!this.delegate.containsKey(k) || !this.equals(v, this.delegate.get(k))) {
                boolean bl = false;
                return bl;
            }
            M m = this.copy();
            m.put(k, v2);
            this.set(m);
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V replace(K k, V v) {
        this.lock.lock();
        try {
            V v2;
            if (!this.delegate.containsKey(k)) {
                V v3 = null;
                return v3;
            }
            M m = this.copy();
            try {
                v2 = m.put(k, v);
                this.set(m);
            }
            catch (Throwable throwable) {
                this.set(m);
                throw throwable;
            }
            return v2;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final V put(K k, V v) {
        this.lock.lock();
        try {
            V v2;
            M m = this.copy();
            try {
                v2 = m.put(k, v);
                this.set(m);
            }
            catch (Throwable throwable) {
                this.set(m);
                throw throwable;
            }
            return v2;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V putIfAbsent(K k, V v) {
        this.lock.lock();
        if (!this.delegate.containsKey(k)) {
            M m = this.copy();
            V v2 = m.put(k, v);
            return v2;
            finally {
                this.set(m);
            }
        }
        Object v3 = this.delegate.get(k);
        return v3;
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public final void putAll(Map<? extends K, ? extends V> map) {
        this.lock.lock();
        try {
            M m = this.copy();
            m.putAll(map);
            this.set(m);
        }
        finally {
            this.lock.unlock();
        }
    }

    protected M copy() {
        this.lock.lock();
        try {
            M m = this.copy((Map)this.delegate);
            return m;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void set(M m) {
        this.delegate = m;
    }

    @Override
    public final Set<Map.Entry<K, V>> entrySet() {
        return this.view.entrySet();
    }

    @Override
    public final Set<K> keySet() {
        return this.view.keySet();
    }

    @Override
    public final Collection<V> values() {
        return this.view.values();
    }

    @Override
    public final boolean containsKey(Object object) {
        return this.delegate.containsKey(object);
    }

    @Override
    public final boolean containsValue(Object object) {
        return this.delegate.containsValue(object);
    }

    @Override
    public final V get(Object object) {
        return this.delegate.get(object);
    }

    @Override
    public final boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public final int size() {
        return this.delegate.size();
    }

    @Override
    public final boolean equals(Object object) {
        return this.delegate.equals(object);
    }

    @Override
    public final int hashCode() {
        return this.delegate.hashCode();
    }

    protected final M getDelegate() {
        return this.delegate;
    }

    public String toString() {
        return this.delegate.toString();
    }

    private boolean equals(Object object, Object object2) {
        if (object == null) {
            return object2 == null;
        }
        return object.equals(object2);
    }

    final class Mutable
    extends View<K, V>
    implements Serializable {
        private static final long serialVersionUID = 1624520291194797634L;
        private final transient KeySet keySet;
        private final transient EntrySet entrySet;
        private final transient Values values;

        Mutable() {
            this.keySet = new KeySet();
            this.entrySet = new EntrySet();
            this.values = new Values();
        }

        @Override
        public Set<K> keySet() {
            return this.keySet;
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return this.entrySet;
        }

        @Override
        public Collection<V> values() {
            return this.values;
        }
    }

    final class Immutable
    extends View<K, V>
    implements Serializable {
        private static final long serialVersionUID = -4158727180429303818L;

        Immutable() {
        }

        @Override
        public Set<K> keySet() {
            return Collections.unmodifiableSet(AbstractCopyOnWriteMap.this.delegate.keySet());
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return Collections.unmodifiableSet(AbstractCopyOnWriteMap.this.delegate.entrySet());
        }

        @Override
        public Collection<V> values() {
            return Collections.unmodifiableCollection(AbstractCopyOnWriteMap.this.delegate.values());
        }
    }

    public static abstract class View<K, V> {
        View() {
        }

        abstract Set<K> keySet();

        abstract Set<Map.Entry<K, V>> entrySet();

        abstract Collection<V> values();

        public static enum Type {
            STABLE{

                @Override
                <K, V, M extends Map<K, V>> View<K, V> get(AbstractCopyOnWriteMap<K, V, M> abstractCopyOnWriteMap) {
                    return abstractCopyOnWriteMap.new Immutable();
                }
            }
            ,
            LIVE{

                @Override
                <K, V, M extends Map<K, V>> View<K, V> get(AbstractCopyOnWriteMap<K, V, M> abstractCopyOnWriteMap) {
                    return abstractCopyOnWriteMap.new Mutable();
                }
            };


            abstract <K, V, M extends Map<K, V>> View<K, V> get(AbstractCopyOnWriteMap<K, V, M> var1);
        }
    }

    protected static abstract class CollectionView<E>
    implements Collection<E> {
        protected CollectionView() {
        }

        abstract Collection<E> getDelegate();

        @Override
        public final boolean contains(Object object) {
            return this.getDelegate().contains(object);
        }

        @Override
        public final boolean containsAll(Collection<?> collection) {
            return this.getDelegate().containsAll(collection);
        }

        @Override
        public final Iterator<E> iterator() {
            return new UnmodifiableIterator<E>(this.getDelegate().iterator());
        }

        @Override
        public final boolean isEmpty() {
            return this.getDelegate().isEmpty();
        }

        @Override
        public final int size() {
            return this.getDelegate().size();
        }

        @Override
        public final Object[] toArray() {
            return this.getDelegate().toArray();
        }

        @Override
        public final <T> T[] toArray(T[] TArray) {
            return this.getDelegate().toArray(TArray);
        }

        @Override
        public int hashCode() {
            return this.getDelegate().hashCode();
        }

        @Override
        public boolean equals(Object object) {
            return this.getDelegate().equals(object);
        }

        public String toString() {
            return this.getDelegate().toString();
        }

        @Override
        public final boolean add(E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean addAll(Collection<? extends E> collection) {
            throw new UnsupportedOperationException();
        }
    }

    private static class UnmodifiableIterator<T>
    implements Iterator<T> {
        private final Iterator<T> delegate;

        public UnmodifiableIterator(Iterator<T> iterator) {
            this.delegate = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public T next() {
            return this.delegate.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class EntrySet
    extends CollectionView<Map.Entry<K, V>>
    implements Set<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        Collection<Map.Entry<K, V>> getDelegate() {
            return AbstractCopyOnWriteMap.this.delegate.entrySet();
        }

        @Override
        public void clear() {
            AbstractCopyOnWriteMap.this.lock.lock();
            try {
                Object m = AbstractCopyOnWriteMap.this.copy();
                m.entrySet().clear();
                AbstractCopyOnWriteMap.this.set(m);
            }
            finally {
                AbstractCopyOnWriteMap.this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean remove(Object object) {
            AbstractCopyOnWriteMap.this.lock.lock();
            try {
                if (!this.contains(object)) {
                    boolean bl = false;
                    return bl;
                }
                Object m = AbstractCopyOnWriteMap.this.copy();
                try {
                    boolean bl = m.entrySet().remove(object);
                    AbstractCopyOnWriteMap.this.set(m);
                    return bl;
                }
                catch (Throwable throwable) {
                    AbstractCopyOnWriteMap.this.set(m);
                    throw throwable;
                }
            }
            finally {
                AbstractCopyOnWriteMap.this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean removeAll(Collection<?> collection) {
            AbstractCopyOnWriteMap.this.lock.lock();
            try {
                Object m = AbstractCopyOnWriteMap.this.copy();
                try {
                    boolean bl = m.entrySet().removeAll(collection);
                    AbstractCopyOnWriteMap.this.set(m);
                    return bl;
                }
                catch (Throwable throwable) {
                    AbstractCopyOnWriteMap.this.set(m);
                    throw throwable;
                }
            }
            finally {
                AbstractCopyOnWriteMap.this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean retainAll(Collection<?> collection) {
            AbstractCopyOnWriteMap.this.lock.lock();
            try {
                Object m = AbstractCopyOnWriteMap.this.copy();
                try {
                    boolean bl = m.entrySet().retainAll(collection);
                    AbstractCopyOnWriteMap.this.set(m);
                    return bl;
                }
                catch (Throwable throwable) {
                    AbstractCopyOnWriteMap.this.set(m);
                    throw throwable;
                }
            }
            finally {
                AbstractCopyOnWriteMap.this.lock.unlock();
            }
        }
    }

    private final class Values
    extends CollectionView<V> {
        private Values() {
        }

        @Override
        Collection<V> getDelegate() {
            return AbstractCopyOnWriteMap.this.delegate.values();
        }

        @Override
        public void clear() {
            AbstractCopyOnWriteMap.this.lock.lock();
            try {
                Object m = AbstractCopyOnWriteMap.this.copy();
                m.values().clear();
                AbstractCopyOnWriteMap.this.set(m);
            }
            finally {
                AbstractCopyOnWriteMap.this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean remove(Object object) {
            AbstractCopyOnWriteMap.this.lock.lock();
            try {
                if (!this.contains(object)) {
                    boolean bl = false;
                    return bl;
                }
                Object m = AbstractCopyOnWriteMap.this.copy();
                try {
                    boolean bl = m.values().remove(object);
                    AbstractCopyOnWriteMap.this.set(m);
                    return bl;
                }
                catch (Throwable throwable) {
                    AbstractCopyOnWriteMap.this.set(m);
                    throw throwable;
                }
            }
            finally {
                AbstractCopyOnWriteMap.this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean removeAll(Collection<?> collection) {
            AbstractCopyOnWriteMap.this.lock.lock();
            try {
                Object m = AbstractCopyOnWriteMap.this.copy();
                try {
                    boolean bl = m.values().removeAll(collection);
                    AbstractCopyOnWriteMap.this.set(m);
                    return bl;
                }
                catch (Throwable throwable) {
                    AbstractCopyOnWriteMap.this.set(m);
                    throw throwable;
                }
            }
            finally {
                AbstractCopyOnWriteMap.this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean retainAll(Collection<?> collection) {
            AbstractCopyOnWriteMap.this.lock.lock();
            try {
                Object m = AbstractCopyOnWriteMap.this.copy();
                try {
                    boolean bl = m.values().retainAll(collection);
                    AbstractCopyOnWriteMap.this.set(m);
                    return bl;
                }
                catch (Throwable throwable) {
                    AbstractCopyOnWriteMap.this.set(m);
                    throw throwable;
                }
            }
            finally {
                AbstractCopyOnWriteMap.this.lock.unlock();
            }
        }
    }

    private class KeySet
    extends CollectionView<K>
    implements Set<K> {
        private KeySet() {
        }

        @Override
        Collection<K> getDelegate() {
            return AbstractCopyOnWriteMap.this.delegate.keySet();
        }

        @Override
        public void clear() {
            AbstractCopyOnWriteMap.this.lock.lock();
            try {
                Object m = AbstractCopyOnWriteMap.this.copy();
                m.keySet().clear();
                AbstractCopyOnWriteMap.this.set(m);
            }
            finally {
                AbstractCopyOnWriteMap.this.lock.unlock();
            }
        }

        @Override
        public boolean remove(Object object) {
            return AbstractCopyOnWriteMap.this.remove(object) != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean removeAll(Collection<?> collection) {
            AbstractCopyOnWriteMap.this.lock.lock();
            try {
                Object m = AbstractCopyOnWriteMap.this.copy();
                try {
                    boolean bl = m.keySet().removeAll(collection);
                    AbstractCopyOnWriteMap.this.set(m);
                    return bl;
                }
                catch (Throwable throwable) {
                    AbstractCopyOnWriteMap.this.set(m);
                    throw throwable;
                }
            }
            finally {
                AbstractCopyOnWriteMap.this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean retainAll(Collection<?> collection) {
            AbstractCopyOnWriteMap.this.lock.lock();
            try {
                Object m = AbstractCopyOnWriteMap.this.copy();
                try {
                    boolean bl = m.keySet().retainAll(collection);
                    AbstractCopyOnWriteMap.this.set(m);
                    return bl;
                }
                catch (Throwable throwable) {
                    AbstractCopyOnWriteMap.this.set(m);
                    throw throwable;
                }
            }
            finally {
                AbstractCopyOnWriteMap.this.lock.unlock();
            }
        }
    }
}

