/*
 * Decompiled with CFR 0.152.
 */
package org.bson.util;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.bson.util.Assertions;
import org.bson.util.CopyOnWriteMap;
import org.bson.util.Function;

final class ComputingMap<K, V>
implements Map<K, V>,
Function<K, V> {
    private final ConcurrentMap<K, V> map;
    private final Function<K, V> function;

    public static <K, V> Map<K, V> create(Function<K, V> function) {
        return new ComputingMap(CopyOnWriteMap.newHashMap(), function);
    }

    ComputingMap(ConcurrentMap<K, V> concurrentMap, Function<K, V> function) {
        this.map = Assertions.notNull("map", concurrentMap);
        this.function = Assertions.notNull("function", function);
    }

    @Override
    public V get(Object object) {
        Object v;
        while ((v = this.map.get(object)) == null) {
            Object object2 = object;
            V v2 = this.function.apply(object2);
            if (v2 == null) {
                return null;
            }
            this.map.putIfAbsent(object2, v2);
        }
        return v;
    }

    @Override
    public V apply(K k) {
        return this.get(k);
    }

    @Override
    public V putIfAbsent(K k, V v) {
        return this.map.putIfAbsent(k, v);
    }

    @Override
    public boolean remove(Object object, Object object2) {
        return this.map.remove(object, object2);
    }

    @Override
    public boolean replace(K k, V v, V v2) {
        return this.map.replace(k, v, v2);
    }

    @Override
    public V replace(K k, V v) {
        return this.map.replace(k, v);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object object) {
        return this.map.containsKey(object);
    }

    @Override
    public boolean containsValue(Object object) {
        return this.map.containsValue(object);
    }

    @Override
    public V put(K k, V v) {
        return this.map.put(k, v);
    }

    @Override
    public V remove(Object object) {
        return this.map.remove(object);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        this.map.putAll(map);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public boolean equals(Object object) {
        return this.map.equals(object);
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }
}

