/*
 * Decompiled with CFR 0.152.
 */
package org.bson.util;

import java.util.Arrays;
import java.util.regex.Pattern;

public class MyAsserts {
    private static Pattern _whiteSpace = Pattern.compile("\\s+", 40);

    public static void assertTrue(boolean bl) {
        if (!bl) {
            throw new MyAssert("false");
        }
    }

    public static void assertTrue(boolean bl, String string) {
        if (!bl) {
            throw new MyAssert("false : " + string);
        }
    }

    public static void assertFalse(boolean bl) {
        if (bl) {
            throw new MyAssert("true");
        }
    }

    public static void assertEquals(int n, int n2) {
        if (n != n2) {
            throw new MyAssert("" + n + " != " + n2);
        }
    }

    public static void assertEquals(long l, long l2) {
        if (l != l2) {
            throw new MyAssert("" + l + " != " + l2);
        }
    }

    public static void assertEquals(char c, char c2) {
        if (c != c2) {
            throw new MyAssert("" + c + " != " + c2);
        }
    }

    public static void assertEquals(short s, short s2) {
        if (s != s2) {
            throw new MyAssert("" + s + " != " + s2);
        }
    }

    public static void assertEquals(byte by, byte by2) {
        if (by != by2) {
            throw new MyAssert("" + by + " != " + by2);
        }
    }

    public static void assertEquals(double d, double d2, double d3) {
        if (Math.abs(d - d2) > d3) {
            throw new MyAssert("" + d + " != " + d2);
        }
    }

    public static void assertEquals(String string, Object object) {
        MyAsserts._assertEquals(string, object == null ? null : object.toString());
    }

    public static void assertSame(Object object, Object object2) {
        if (object != object2) {
            throw new MyAssert(object + " != " + object2);
        }
    }

    public static void assertEquals(Object object, Object object2) {
        MyAsserts._assertEquals(object, object2);
    }

    public static void _assertEquals(Object object, Object object2) {
        if (object == null) {
            if (object2 == null) {
                return;
            }
            throw new MyAssert("left null, right not");
        }
        if (object.equals(object2)) {
            return;
        }
        throw new MyAssert("[" + object + "] != [" + object2 + "] ");
    }

    public static void assertEquals(String string, String string2, String string3) {
        if (string.equals(string2)) {
            return;
        }
        throw new MyAssert("[" + string + "] != [" + string2 + "] " + string3);
    }

    public static void assertArrayEquals(byte[] byArray, byte[] byArray2) {
        if (Arrays.equals(byArray, byArray2)) {
            return;
        }
        throw new MyAssert("These arrays are different, but they might be big so not printing them here");
    }

    public static void assertArrayEquals(char[] cArray, char[] cArray2) {
        if (Arrays.equals(cArray, cArray2)) {
            return;
        }
        throw new MyAssert("These arrays are different, but they might be big so not printing them here");
    }

    public static void assertNotEquals(Object object, Object object2) {
        if (object == null) {
            if (object2 != null) {
                return;
            }
            throw new MyAssert("left null, right null");
        }
        if (!object.equals(object2)) {
            return;
        }
        throw new MyAssert("[" + object + "] == [" + object2 + "] ");
    }

    public static void assertClose(String string, Object object) {
        MyAsserts.assertClose(string, object == null ? "null" : object.toString());
    }

    public static void assertClose(String string, String string2) {
        MyAsserts.assertClose(string, string2, "");
    }

    public static void assertClose(String string, String string2, String string3) {
        if (MyAsserts.isClose(string, string2)) {
            return;
        }
        throw new MyAssert(string3 + "[" + string + "] != [" + string2 + "]");
    }

    public static boolean isClose(String string, String string2) {
        string = MyAsserts._simplify(string);
        string2 = MyAsserts._simplify(string2);
        return string.equalsIgnoreCase(string2);
    }

    private static String _simplify(String string) {
        string = string.trim();
        string = _whiteSpace.matcher(string).replaceAll("");
        return string;
    }

    public static void assertNull(Object object) {
        if (object == null) {
            return;
        }
        throw new MyAssert("not null [" + object + "]");
    }

    public static void assertNotNull(Object object) {
        if (object != null) {
            return;
        }
        throw new MyAssert("null");
    }

    public static void assertLess(long l, long l2) {
        if (l < l2) {
            return;
        }
        throw new MyAssert(l + " is higher than " + l2);
    }

    public static void assertLess(double d, double d2) {
        if (d < d2) {
            return;
        }
        throw new MyAssert(d + " is higher than " + d2);
    }

    public static void assertEmptyString(String string) {
        if (!string.equals("")) {
            throw new MyAssert(string);
        }
    }

    public static void fail(String string) {
        throw new MyAssert(string);
    }

    public static class MyAssert
    extends RuntimeException {
        private static final long serialVersionUID = -4415279469780082174L;
        final String _s;

        MyAssert(String string) {
            super(string);
            this._s = string;
        }

        @Override
        public String toString() {
            return this._s;
        }
    }
}

