#!/bin/bash
# update statistics for tables

############################## check  ##############################################
#db env check
if [ "${GBASEDBTSERVER}x" = "x" ]; then
  echo "GBASEDBTSERVER Environment variable error!!!";
  exit 1;
fi
#db run check
db_is_running=$(onstat - | grep 'On-Line' | wc -l)
if [ ${db_is_running} -eq 0 ]; then
  echo "GBASEDBTSERVER NOT running!!!";
  exit 2;
fi

# STOPTIME 600 -> 6:00
STOPTIME=600
DATESTR=$(date +%Y%m%d)
WORKDIR=$(cd $(dirname $0) && pwd)/ups_${DATESTR}
LOGFILE=$(cd $(dirname $0) && pwd)/upslog.log

############################## function : _loginfo  #########################################
_loginfo(){
  echo -e "[$(date +'%Y-%m-%d %H:%M:%S')] $*" >> ${LOGFILE}
}

############################## function : ups  ##############################################
# ups ${DBNAME}
ups(){
  DBNAME=$1
  if [ x"${DBNAME}" = x ]; then
    return 
  fi
  ##1.high ups
  cat << EOF >> ups.all.sql
database ${DBNAME}; set PDQPRIORITY 10; set lock mode to wait 20; update statistics;
database ${DBNAME}; set PDQPRIORITY 10; set lock mode to wait 20; update statistics for procedure; 
database ${DBNAME}; set PDQPRIORITY 10; set lock mode to wait 20; update statistics for routine; 
database ${DBNAME}; set PDQPRIORITY 10; set lock mode to wait 20; update statistics for function; 
EOF
  
  ##get index first field
  dbaccess ${DBNAME} <<EOF >/dev/null 2>&1
  unload to indexTop1.list DELIMITER ' '
  select t.tabname,c.colname
  from sysindexes i,systables t,syscolumns c
  where i.tabid = t.tabid
  and t.tabid = c.tabid
  and c.colno = i.part1
  and t.tabid > 99
  and t.tabtype = 'T';
EOF
  
  ##get index first field and duplicate removal
  if [ -f indexTop1.list ]; then
    sort indexTop1.list | uniq > indexTop2.list
  fi
  
  ##2.high ups
  if [ -f indexTop2.list ]; then
    while read TABNAME COLNAME
    do
      cat << EOF >> ups.all.sql
database ${DBNAME}; set PDQPRIORITY 10; set lock mode to wait 20; update statistics high for table ${TABNAME}(${COLNAME});
EOF
    done < indexTop2.list
  fi
  
  [ -f indexTop1.list ] && rm -f indexTop1.list
  [ -f indexTop2.list ] && rm -f indexTop2.list
}


############################## create ${dbName}.ups.sql  ####################################
createSQL(){
  #db list
  dbaccess sysmaster <<EOF > /dev/null 2>&1
  unload to dbname.list delimiter ' '
  select name from sysdatabases 
  where name not in ('sysmaster','sysutils','sysuser','sysadmin','sysha','syscdr','syscdcv1');
EOF
    
  #collect ${dbName}.ups.sql
  cat << EOF > ups.all.sql
database sysmaster;  set PDQPRIORITY 10;  set lock mode to wait 20;  update statistics;  
database sysutils;  set PDQPRIORITY 10;  set lock mode to wait 20;  update statistics; 
database sysuser;  set PDQPRIORITY 10;  set lock mode to wait 20;  update statistics;
database sysadmin;  set PDQPRIORITY 10;  set lock mode to wait 20;  update statistics; 
EOF

  #one by one create ${dbName}.ups.sql 
  while read dbName
  do
    ups ${dbName}
  done < dbname.list
  
  echo "All_SQL_Execution_complete" >> ups.all.sql
}


############################## exec and time ctl  #######################################
if [ ! -d ${WORKDIR} ]; then
  mkdir -p ${WORKDIR}
fi
cd ${WORKDIR}

createSQL

# running before 6:00
LNum=1
while read LINE
do
  ET=$(date +%H%M)
  if [ ${ET} -le ${STOPTIME:-600} ]; then
    _loginfo "$LNum $LINE"
    if [ ! x"${LINE}" = "xAll_SQL_Execution_complete" ]; then 
      echo "$LINE" | dbaccess - >/dev/null 2>&1
      if [ ! $? -eq 0 ]; then
        _loginfo "ERROR: Line ${LNum}:[${LINE}] !"
      fi
    fi
  fi
  LNum=$((LNum+1))
done < ups.all.sql

exit 0
